/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class HydrophilousModifier
extends Modifier {
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        if (player != null && player.m_204029_(FluidTags.f_13131_)) {
            if (player.m_21023_(MobEffects.f_19599_)) {
                int amplifier = player.m_21124_(MobEffects.f_19599_).m_19564_() + 1;
                double scale = amplifier <= 3 ? Math.pow(3.0, amplifier) : Math.pow(3.0, 4.0);
                BlockState state = event.getState();
                event.setNewSpeed((float)((double)event.getNewSpeed() * scale * scale));
            } else if (!ModifierUtil.hasAquaAffinity((LivingEntity)player)) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            } else {
                event.setNewSpeed(event.getNewSpeed() + (float)(5 * level));
            }
        }
    }

    public int getPriority() {
        return 60;
    }

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player.m_204029_(FluidTags.f_13131_)) {
            return damage + (float)(level * 5);
        }
        return damage;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (player.m_204029_(FluidTags.f_13131_)) {
            this.addStatTooltip(tool, ToolStats.ATTACK_DAMAGE, TinkerTags.Items.MELEE, 5 * level, tooltip);
            if (player.m_21023_(MobEffects.f_19599_)) {
                double percent;
                double scale;
                int amplifier = player.m_21124_(MobEffects.f_19599_).m_19564_() + 1;
                if (amplifier <= 3) {
                    scale = Math.pow(3.0, amplifier);
                    percent = Math.pow(0.3, amplifier);
                } else {
                    scale = Math.pow(3.0, 4.0);
                    percent = Math.pow(0.3, 4.0);
                }
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.hydrophilous.mining_speed1"), percent * scale, tooltip);
            } else if (!ModifierUtil.hasAquaAffinity((LivingEntity)player)) {
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.hydrophilous.mining_speed2"), 5.0, tooltip);
            } else {
                this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, 5 * level, tooltip);
            }
        }
    }
}

